#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

#endregion

namespace gov.va.med.vbecs.DAL.HL7AL.UnitTests
{
	[TestFixture]
	public class HL7AL_HL7Broker : BaseTest
	{
		private static UnitTestHL7Broker _broker;
		private static HL7Interface _intParms;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			_broker = new UnitTestHL7Broker();
			_intParms = new HL7Interface("CPRS");
		}

		[TearDown]
		protected void TearDown()
		{
			_broker.Close();
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void Logon_Pass()
		{
			// This method requires a valid VistA system to connect to and is not tesTABLES.
			// This method is tested indirectly through other methods.
		}

		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void Logon_Fail()
		{
			_broker.Logon(null);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void ExecuteHL7Send_Pass()
		{
			// This method requires a valid order message from CPRS and is not tesTABLES.
			// This method is tested indirectly through other methods.
		}

		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void ExecuteHL7Send_Fail()
		{
			HL7ProtocolMessage msg = _broker.ExecuteHL7Send(null);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void Close_Pass()
		{
			// This method requires a valid VistA system with a connection and is not tesTABLES.
			// This method is tested indirectly through other methods.
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Close_Fail()
		{}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void IsLoggedOn_Pass()
		{
			// This method requires a valid VistA system with a connection and is not tesTABLES.
			// This method is tested indirectly through other methods.
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsLoggedOn_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void InterfaceConnectionInfo_Pass()
		{
			// This method requires a valid VistA system with a connection and is not tesTABLES.
			// This method is tested indirectly through other methods.
		}

		[Test]
		public void InterfaceConnectionInfo_Fail()
		{
			Assert.IsNull(_broker.InterfaceConnectionInfo);
		}
	}

	internal class UnitTestHL7Broker : HL7Broker
	{
		internal UnitTestHL7Broker() : base() {}
	}

}
#endif
